// Version : Scilab 5.2.2
// Operating Syatem : Ubuntu 16.04 LTS

clc;        clear;      xdel(winsid()); 
fc=20000;   fs=44100;   M=63;                                              //Filter order
wc=2*fc/fs;
[wft,wfm,fr]=wfir('hp',M,[wc/2,0],'hm',[0,0]);      //Fir Filter
figure(1)
subplot(2,1,1);          plot(2*fr,wfm);
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR HPF');      xgrid(1)
subplot(2,1,2);          plot(fr*fs,wfm);
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR HPF');      xgrid(1)

[d,Fs]=wavread("22000.wav") 
playsnd(d,Fs)       //single tone high frequency sound wave
L = length(d);      a=1+nextpow2(L);        N=2*(2^a);
noise = rand(1,L);           data = d+noise;     playsnd(data);
outhi = filter(wft,1,data);  playsnd(outhi);

figure(2)
subplot(3,1,1);      plot(d(1:200));
title('Input sound');
subplot(3,1,2);      plot(data(1:200));
title('Sound with noise component');
subplot(3,1,3);      plot(outhi(1:200));
title('Output after filtering');


